﻿using log4net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.AddressValidationService.Interface;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Api.Controllers
{
    [Route("[controller]/v1")]
    public class ValidateAddressController : Controller
    {
        private readonly ILog _logger;
        private readonly IAddressValidationService _addressValidationService;
        
        public ValidateAddressController(ILog logger, IAddressValidationService addressValidationService)
        {
            _logger = logger;
            _addressValidationService = addressValidationService;
        }

        [HttpGet]
        public async Task<IActionResult> Get(string streetAddress, string city, string state, string zip)
        {
            try
            {
                _logger.Info("@@@@@ Info - Start GET for ValidateAddressController @@@@@");

                var request = new RootObjectRequest
                {
                    requestAddress = new Address
                    {
                        addressLine1 = streetAddress,
                        city = city,
                        stateProvince = new StateProvince
                        {
                            name = state
                        },
                        zipCode5 = zip
                    }
                };

                var response = await _addressValidationService.ValidateAddress(request);

                if (response != null) return StatusCode(StatusCodes.Status200OK, response);

                _logger.Error("@@@@ ERROR - The response returned from the Address Validation Service is null");
                return StatusCode(StatusCodes.Status500InternalServerError, "The response returned from the Address Validation Service is null");
            }
            catch (Exception ex)
            {
                _logger.Error($"@@@@ ERROR - PPMS Validate Address Failure @@@@", ex);
                return StatusCode(StatusCodes.Status500InternalServerError, ex);
            }
        }
    }
}